<?php

namespace App\Utils;

use Throwable;
use Illuminate\Support\Facades\Http;

class AfterShip
{

    const API_BASE_URL               = 'https://api.aftership.com/';

    const ROUTE_GET_TRACKINGS        = 'tracking/2024-07/trackings';
    const ROUTE_GET_TRACKING         = 'tracking/2024-07/trackings';
    const ROUTE_POST_COURIER         = 'tracking/2024-07/couriers/detect';
    const ROUTE_POST_TRACKINGS       = 'tracking/2024-07/trackings';

    public function _callApiData($route, $method = 'GET', $sendData = null)
    {
        try {

            $https = Http::withOptions([
                'base_uri' => self::API_BASE_URL,
            ])->withHeaders([
                'as-api-key' => env('AFTERSHIP_API_KEY'),
                'Content-Type' => 'application/json',
            ]);
            $response = null;

            if ($method == 'GET') {
                $response = $https->get($route);
            } else if ($method == 'POST') {
                $response = $https->post($route, $sendData);
            } else if ($method == 'PUT') {
                $response = $https->put($route, $sendData);
            }

            return $response->json();

            // if ($response->successful()) {
            //     $responseData = $response->json();
            //     return $responseData;  
            // } else {
            //     return response()->json([
            //         'error' => 'API request failed',
            //         'status' => $response->status(),
            //         'message' => $response->body(),
            //     ]);
            // }
        } catch (Throwable $e) {
            return response()->json([
                'error' => 'Request error',
                'message' => $e->getMessage(),
            ]);
        }
    }

    function getTrackings($tracking_number)
    {
        try {
            $route = self::ROUTE_GET_TRACKINGS . '?tracking_numbers=' . $tracking_number ;
            $method = 'GET';
            $sendData = null;
            $res = $this->_callApiData($route, $method, $sendData);
            if (is_string($res)) {
                $res = json_decode($res, true);
            }
            if ($res['meta']['code'] == HTTP_OK) {
                return [
                    'status' => HTTP_OK,
                    'data' => $res['data']
                ];
            } else {
                return [
                    'status' => $res['meta']['code'],
                    'message' => $res['meta']['message']
                ];
            }
        } catch (\Throwable $th) {
            return [
                'status' => HTTP_BAD_REQUEST,
                'message' => "Xảy ra lỗi khi gọi đến api",
                'errors' => $th->getMessage() 
            ];
        }
    }

    function getTracking($tracking_number){

    }

    function postCourier($tracking_number)
    {
        try {
            $route = self::ROUTE_POST_COURIER;
            $method = 'POST';
            $sendData = [
                "tracking_number" => $tracking_number
            ];
            $res = $this->_callApiData($route, $method, $sendData);
            if (is_string($res)) {
                $res = json_decode($res, true);
            }
            if ($res['meta']['code'] == HTTP_OK) {
                return [
                    'status' => HTTP_OK,
                    'data' => $res['data']
                ];
            } else {
                return [
                    'status' => $res['meta']['code'],
                    'message' => $res['meta']['message']
                ];
            }
        } catch (\Throwable $th) {
            return [
                'status' => HTTP_BAD_REQUEST,
                'message' => "Xảy ra lỗi khi gọi đến api"
            ];
        }
    }


    function postTracking($tracking_number, $send_data)
    {
        try {
            $route = self::ROUTE_POST_TRACKINGS;
            $method = 'POST';
            $sendData = $send_data;
            $res = $this->_callApiData($route, $method, $sendData);
            if (is_string($res)) {
                $res = json_decode($res, true);
            }
            if ($res['meta']['code'] == HTTP_OK || in_array($res['meta']['code'], [201, HTTP_OK])) {
                return [
                    'status' => HTTP_OK,
                    'data' => $res['data']
                ];
            } else {
                return [
                    'status' => $res['meta']['code'],
                    'message' => $res['meta']['message'] ?? 'Xảy ra lỗi response api'
                ];
            }
        } catch (\Throwable $th) {
            return [
                'status' => HTTP_BAD_REQUEST,
                'message' => "Xảy ra lỗi khi gọi đến api",
                'error' => $th->getMessage(),
            ];
        }
    }
}
