<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class WeightChildPriceList extends Model
{
    protected $table = 'weights_child_price_list';
    protected $primaryKey = 'weight_child_price_list_id';
    protected $guarded = [];
    use HasFactory;
   
    public function itemsSubChildPriceList()
    {
        return $this->hasMany(ItemChildPriceList::class, 'weight_child_price_list_id', 'weight_child_price_list_id')->isActive(ACTIVE)->isDelete(NO_DELETE);
    }

    public function weightChildPriceListArea()
    {
        return $this->hasMany(WeightChildPriceListArea::class, 'weight_child_price_list_id', 'weight_child_price_list_id')->isActive(ACTIVE)->isDelete(NO_DELETE);
    }
    public function scopeIsDelete($query, $delete_flg)
    {
        return $query->where('weights_child_price_list.delete_flg', $delete_flg);
    }

    public function scopeIsActive($query, $active_flg)
    {
        return $query->where('weights_child_price_list.active_flg', $active_flg);
    }
}
