<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class WalletFluctuation extends Model
{
    protected $table = 'wallet_fluctuations';
    protected $primaryKey = 'wallet_fluctuation_id';
    protected $guarded = [];
    use HasFactory;

    public function scopeIsFilters($query, $filters)
    {
        if (isset($filters['status'])) {
            $query->where('wallet_fluctuations.status', $filters['status']);
        }
        if (isset($filters['kind'])) {
            $query->where('wallet_fluctuations.kind', $filters['kind']);
        }
        if (isset($filters['start_date'])) {

            $query->where('wallet_fluctuations.created_at', '>=', $filters['start_date']);
        }
        if (isset($filters['end_date'])) {
            $query->where('wallet_fluctuations.created_at', '<=', $filters['end_date']);
        }

        $date_range = $filters['date_range'] ?? null;
        if ( isset($date_range) && !empty($date_range['start_date']) && !empty($date_range['end_date'])) {
            $start_date = Carbon::parse($date_range['start_date'])->startOfDay()->toDateTimeLocalString();
            $end_date = Carbon::parse($date_range['end_date'])->endOfDay()->toDateTimeLocalString();
            $query->whereBetween("wallet_fluctuations.created_at", [$start_date, $end_date]);
        }
        if (isset($filters['key_type']) && isset($filters['keywords'])) {
            switch ($filters['key_type']) {
                case 'code':
                    $filters['key_type'] = 'secure_hash';
                    break;
                case 'note':
                    $filters['key_type'] = 'content';
                    break;
                default:
                    break;
            }
            $query->where('wallet_fluctuations.' . $filters['key_type'], 'like', '%' . $filters['keywords'] . "%");
        } else if (isset($filters['keywords']) && $filters['keywords'] != '') {
            $keywords = convertSearchString($filters['keywords']);
            $query->where(function ($q) use ($keywords) {
                return $q->where('wallet_fluctuations.secure_hash', 'like', $keywords)
                    ->orWhere('wallet_fluctuations.content', 'like', $keywords);
            });
        }

        return $query;
    }

    public function scopeIsShow($query)
    {
        return $query->where('wallet_fluctuations.active_flg', ACTIVE)
            ->where('wallet_fluctuations.delete_flg', NO_DELETE);
    }

    public function scopeIsPaginate($query, $paginate)
    {
        $limit = !empty($paginate['limit']) ? $paginate['limit'] : 10;
        $page = !empty($paginate['page']) ? $paginate['page'] : 1;

        return $query->paginate($limit, ['*'], 'page', $page);
    }
}
