<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Town extends Model
{
    protected $table = 'town';
    protected $primaryKey = 'town_id';
    protected $guarded = [];
    use HasFactory;

    public function service()
    {
        return $this->belongsTo(Service::class, 'service_id', 'service_id')->select('service_id', 'service_name');
    }

    public function scopeIsFilters($query, $filters = [])
    {
        if (!empty($filters)) {
            if (isset($filters['keywords']) && $filters['keywords'] != "") {
                $query->where(function ($query) use ($filters) {
                    return $query->where('town.town_name', 'like', '%' . $filters['keywords'] . '%')
                        ->orWhere('town.town_postal_code', 'like', '%' . $filters['keywords'] . '%')
                        ->orWhere('town.town_zone_code', 'like', '%' . $filters['keywords'] . '%');
                });
            }
            if (isset($filters['country_id']) && $filters['country_id'] != "") {
                $query->where('town.country_id', $filters['country_id']);
            }

            if (isset($filters['state_id']) && $filters['state_id'] != "") {
                $query->where('town.state_id', $filters['state_id']);
            }
        }
        return $query;
    }

    public function country()
    {
        return $this->belongsTo(Country::class, 'country_id', 'country_id');
    }

    public function state()
    {
        return $this->belongsTo(State::class, 'state_id', 'state_id');
    }
}
