<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Ticket extends Model
{
    protected $table = 'tickets';
    protected $primaryKey = 'ticket_id';
    protected $guarded = [];
    use HasFactory;

    public function ticketMessages()
    {
        return $this->hasMany(TicketMessage::class, 'ticket_id', 'ticket_id');
    }

    public function ticketMessage()
    {
        return $this->belongsTo(TicketMessage::class, 'ticket_id', 'ticket_id')->orderBy('created_at', 'ASC');
    }

    public function shipments()
    {
        return $this->hasMany(Shipment::class, 'user_id', 'user_id');
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id', 'user_id');
    }
}
