<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SurchargeGoods extends Model
{
    protected $table = 'surcharge_goods';
    protected $primaryKey = 'surcharge_goods_id';
    protected $guarded = [];
    use HasFactory;

    public function scopeIsDelete($query, $delete_flg)
    {
        return $query->where('surcharge_goods.delete_flg', $delete_flg);
    }

    public function scopeIsActive($query, $active_flg)
    {
        return $query->where('surcharge_goods.active_flg', $active_flg);
    }

    public function scopeIsShow($query)
    {
        return $query->where('surcharge_goods.delete_flg', NO_DELETE)->where('surcharge_goods.active_flg', ACTIVE);
    }

    public function getActiveNameAttribute()
    {
        $arr = [
            ACTIVE => 'Đang hoạt động',
            INACTIVE => 'Dừng hoạt động',
        ];
        return $arr[$this->active_flg];
    }
}
