<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class StatementItem extends Model
{
    protected $table = 'statement_items';
    protected $primaryKey = 'statement_item_id';
    protected $guarded = [];
    use HasFactory;

    public function scopeIsShow($query)
    {
        return $query->where('statement_items.active_flg', ACTIVE)->where('statement_items.delete_flg', NO_DELETE);
    }

    public function scopeIsPaginate($query, $paginate)
    {
        $limit = !empty($paginate['limit']) ? $paginate['limit'] : 10;
        $page = !empty($paginate['page']) ? $paginate['page'] : 1;

        return $query->paginate($limit, ['*'], 'page', $page);
    }
}
