<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Statement extends Model
{
    protected $table = 'statements';
    protected $primaryKey = 'statement_id';
    protected $guarded = [];
    use HasFactory;

    public function scopeIsShow($query)
    {
        return $query->where('statements.active_flg', ACTIVE)->where('statements.delete_flg', NO_DELETE);
    }

    public function scopeIsPaginate($query, $paginate)
    {
        $limit = !empty($paginate['limit']) ? $paginate['limit'] : 10;
        $page = !empty($paginate['page']) ? $paginate['page'] : 1;

        return $query->paginate($limit, ['*'], 'page', $page);
    }

    public function scopeIsFilters($query, $filters = null)
    {
        if ($filters) {
            $date_range = $filters['date_range'] ?? null;
            $start_date = isset($date_range['start_date']) ? Carbon::parse($date_range['start_date'])->format('y-m-d h:m:s') : null;
            $end_date = isset($date_range['end_date']) ? Carbon::parse($date_range['end_date'])->endOfDay()->format('y-m-d h:m:s') : null;
            if ($start_date && $end_date) {
                $query = $query->whereBetween("statements.created_at", [$start_date, $end_date]);;
            }

            if (isset($filters['keywords']) && $filters['keywords'] != '') {
                $keywords = $filters['keywords'];
                $query = $query->where(function ($query) use ($keywords) {
                    $query = $query->where('statements.statement_code', 'like', '%' . $keywords . '%');
                });
            }

            if (isset($filters['statement_status']) && $filters['statement_status'] != '') {
                $query = $query->where('statements.statement_status', $filters['statement_status']);
            }
            if (isset($filters['checked_payment_status']) && $filters['checked_payment_status'] != "") {
                $query->where("statements.checked_payment_status", $filters['checked_payment_status']);
            }
            if (isset($filters['statement_payment_method']) && in_array($filters['statement_payment_method'], [0, 1, 2])) {
                $query = $query->where('statements.statement_payment_method', $filters['statement_payment_method']);
            }
        }
        return $query;
    }

    public function checked_payment()
    {
        return $this->belongsTo(CheckedPaymentCash::class, 'statement_code', 'code');
    }

    public function getStatementPaymentMethodNameAttribute()
    {
        try {
            $arr = config('constans.constans.payment_status_name');
            return $arr[$this->statement_payment_method] ?? 'Không xác định';
        } catch (\Throwable $th) {
            return "Lỗi";
        }
    }
}
