<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class State extends Model
{
    protected $table = 'states';
    protected $primaryKey = 'state_id';
    protected $guarded = [];
    use HasFactory;

    public function country()
    {
        return $this->belongsTo(Country::class, 'country_id', 'country_id')->isDelete(NO_DELETE);
    }

    public function scopeIsFilters($query, $filters = [])
    {
        if (!empty($filters)) {
            if (
                (isset($filters['date_range']['start_date']) && $filters['date_range']['start_date'] != "")
                && isset($filters['date_range']['end_date']) && $filters['date_range']['end_date'] != ""
            ) {
                $start_date = Carbon::parse($filters['date_range']['start_date'])->startOfDay()->toDateTimeLocalString();
                $end_date = Carbon::parse($filters['date_range']['end_date'])->endOfDay()->toDateTimeLocalString();
                $query->whereBetween("states.created_at", [$start_date, $end_date]);
            }
            if (isset($filters['keywords']) && $filters['keywords'] != "") {
                $query->where(function ($query) use ($filters) {
                    return $query->where('states.state_post_code', 'like', '%' . $filters['keywords'] . '%')
                        ->orWhere('states.state_name', 'like', '%' . $filters['keywords'] . '%')
                        ->orWhere('states.state_code', 'like', '%' . $filters['keywords'] . '%');
                });
            }
            if (isset($filters['country_id']) && $filters['country_id'] != "") {
                $query->where('states.country_id', $filters['country_id']);
            }
        }
        return $query;
    }

    public function scopeIsDelete($query, $delete_flg)
    {
        return $query->where('states.delete_flg', $delete_flg);
    }

    public function scopeIsActive($query, $active_flg)
    {
        return $query->where('states.active_flg', $active_flg);
    }

    public function scopeIsCountry($query, $country_id)
    {
        return $query->where('states.country_id', $country_id);
    }

    public function getActiveNameAttribute()
    {
        $arr = [
            ACTIVE => 'Đang hoạt động',
            INACTIVE => 'Dừng hoạt động',
        ];
        return $arr[$this->active_flg];
    }

    public function scopeIsPaginate($query, $paginate)
    {
        $limit = !empty($paginate['limit']) ? $paginate['limit'] : 10;
        $page = !empty($paginate['page']) ? $paginate['page'] : 1;

        return $query->paginate($limit, ['*'], 'page', $page);
    }
}
