<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class SmsHistory extends Model
{
    protected $table = 'sms_histories';
    protected $primaryKey = 'sms_history_id';
    protected $guarded = [];
    use HasFactory;

    public function scopeIsFilters($query, $filters = [])
    {
        if (!empty($filters)) {
            if (
                (isset($filters['date_range']['start_date']) && $filters['date_range']['start_date'] != "")
                && isset($filters['date_range']['end_date']) && $filters['date_range']['end_date'] != ""
            ) {
                $start_date = Carbon::parse($filters['date_range']['start_date'])->startOfDay()->toDateTimeLocalString();
                $end_date = Carbon::parse($filters['date_range']['end_date'])->endOfDay()->toDateTimeLocalString();
                $query->whereBetween("sms_histories.created_at", [$start_date, $end_date]);
            }
            if (isset($filters['keywords']) && $filters['keywords'] != "") {
                $query->where(function ($query) use ($filters) {
                    return $query->where('shipments.receiver_contact_name', 'like', '%' . $filters['keywords'] . '%')
                        ->orWhere('shipments.receiver_telephone', 'like', '%' . $filters['keywords'] . '%');
                });
            }
        }
        return $query;
    }
    
    public function scopeIsShow($query){
        return $query->where('sms_histories.active_flg', ACTIVE)->where('sms_histories.active_flg', NO_DELETE);
    }

    public function scopeIsPaginate($query, $paginate)
    {
        $limit = isset($paginate['limit']) ? $paginate['limit'] : 10;
        $page = isset($paginate['page']) ? $paginate['page'] : 1;
        return $query->paginate($limit, ['*'], 'page', $page);
    }
}
