<?php

namespace App\Models;

use Illuminate\Support\Facades\DB;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class ShipmentTracktry extends Model
{
    use HasFactory;
    protected $table = 'shipments_tracktry';
    protected $primaryKey = 'sm_tracktry_id';
    protected $guarded = [];


    public function scopeIsShow($query)
    {
        return $query->where('shipments_tracktry.delete_flg', NO_DELETE)->where('shipments_tracktry.active_flg', ACTIVE);
    }

    public function scopeIsPaginate($query, $paginate = null)
    {
        $limit = !empty($paginate['limit']) ? $paginate['limit'] : 10;
        $page = !empty($paginate['page']) ? $paginate['page'] : 1;

        return $query->paginate($limit, ['*'], 'page', $page);
    }

    public function branch()
    {
        return $this->belongsTo(Branch::class, 'branch_id', 'branch_id');
    }

    public function packages()
    {
        return $this->hasMany(Package::class, 'sm_tracktry_id', 'sm_tracktry_id')
            ->where('packages.delete_flg', NO_DELETE)
            ->where('packages.active_flg', ACTIVE);
    }

    public function getDataConvertPackages()
    {
        $packages = $this->hasMany(Package::class, 'sm_tracktry_id', 'sm_tracktry_id')
            ->where('packages.delete_flg', NO_DELETE)
            ->where('packages.active_flg', ACTIVE)
            ->leftJoin('shipments', 'packages.shipment_id', 'shipments.shipment_id')
            ->leftJoin('services', 'shipments.shipment_service_id', 'services.service_id')
            ->select(
                'packages.package_id',
                'packages.sm_tracktry_id',
                'packages.package_code',
                'packages.bag_code',
                DB::raw('COUNT(DISTINCT package_id) AS count_package'),
                DB::raw('COUNT(DISTINCT bag_code) AS count_bag'),
                DB::raw('COUNT(DISTINCT package_weight) AS gross_weight'),
                DB::raw('COUNT(DISTINCT package_charged_weight) AS charged_weight'),
            )->groupBy('packages.sm_tracktry_id')->first();

        return $packages;
    }
}
