<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ShipmentTrackingStatus extends Model
{
    use HasFactory;
    protected $table = 'shipment_tracking_status';
    protected $primaryKey = 'tracking_status_id';
    protected $guarded = [];


    public function scopeIsShow($query)
    {
        return $query->where('shipment_tracking_status.delete_flg', NO_DELETE)->where('shipment_tracking_status.active_flg', ACTIVE);
    }

    public function scopeIsPaginate($query, $paginate = null)
    {
        $limit = !empty($paginate['limit']) ? $paginate['limit'] : 10;
        $page = !empty($paginate['page']) ? $paginate['page'] : 1;

        return $query->paginate($limit, ['*'], 'page', $page);
    }
}
