<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class SetAmountShipment extends Model
{
    protected $table = 'set_amount_origin_shipment';
    protected $primaryKey = 'id';
    protected $guarded = [];
    use HasFactory;

    public function scopeIsShow($query)
    {
        return $query->where('set_amount_origin_shipment.active_flg', ACTIVE)
            ->where('set_amount_origin_shipment.delete_flg', NO_DELETE);
    }

    public function scopeIsPaginate($query, $paginate)
    {
        $limit = isset($paginate['limit']) ? $paginate['limit'] : 10;
        $page = isset($paginate['page']) ? $paginate['page'] : 1;
        return $query->paginate($limit, ['*'], 'page', $page);
    }

    public function scopeIsFilters($query, $filters = [])
    {
        if (!empty($filters)) {
            if (
                (isset($filters['date_range']['start_date']) && $filters['date_range']['start_date'] != "")
                && isset($filters['date_range']['end_date']) && $filters['date_range']['end_date'] != ""
            ) {
                $start_date = Carbon::parse($filters['date_range']['start_date'])->startOfDay()->toDateTimeLocalString();
                $end_date = Carbon::parse($filters['date_range']['end_date'])->endOfDay()->toDateTimeLocalString();
                $query->whereBetween("set_amount_origin_shipment.created_at", [$start_date, $end_date]);
            }

            if (isset($filters['keywords']) && $filters['keywords'] != "") {
                $query->where(function ($query) use ($filters) {
                    $filter_by = isset($filters['filter_by']) ? $filters['filter_by'] : 'shipment_code';
                    return $query->where("set_amount_origin_shipment.$filter_by", 'like', '%' . $filters['keywords'] . '%');
                });
            }
        }
        return $query;
    }
}
