<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ServiceSurchargeFee extends Model
{
    protected $table = 'service_surcharge_fees';
    protected $primaryKey = 'service_surcharge_fee_id';
    protected $guarded = [];
    use HasFactory;

    public function scopeIsShow($query)
    {
        return $query->where('service_surcharge_fees.delete_flg', NO_DELETE)->where('service_surcharge_fees.active_flg', ACTIVE);
    }

    public function scopeIsPaginate($query, $paginate)
    {
        $limit = !empty($paginate['limit']) ? $paginate['limit'] : 10;
        $page = !empty($paginate['page']) ? $paginate['page'] : 1;

        return $query->paginate($limit, ['*'], 'page', $page);
    }

    public function scopeIsFilters($query, $filters)
    {
        if (isset($filters['start_date']) && isset($filters['end_date'])) {
            $start_date = Carbon::parse($filters['start_date'])->toDateTimeLocalString();
            $end_date = Carbon::parse($filters['end_date'])->endOfDay()->toDateTimeLocalString();
            $query->whereBetween('service_surcharge_fees.created_at', [$start_date, $end_date]);
        }
        if (isset($filters['keywords']) && $filters['keywords'] != '') {
            $keywords = convertSearchString($filters['keywords']);
            $query->where(function ($q) use ($keywords) {
                return $q->where('service_surcharge_fees.surcharge_name', 'like', $keywords);
            });
        }
        return $query;
    }

    public function service()
    {
        return $this->belongsTo(Service::class, 'service_id');
    }
}
