<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Service extends Model
{
    protected $table = 'services';
    protected $primaryKey = 'service_id';
    protected $guarded = [];
    use HasFactory;

    public function logoService()
    {
        return $this->belongsTo(LogoService::class, 'service_id', 'service_id');
    }

    public function scopeIsDelete($query, $delete_flg)
    {
        return $query->where('services.delete_flg', $delete_flg);
    }

    public function scopeIsActive($query, $active_flg)
    {
        return $query->where('services.active_flg', $active_flg);
    }

    public function scopeIsShow($query)
    {
        return $query->where('services.active_flg', ACTIVE)->where('services.delete_flg', NO_DELETE);
    }

    public function scopeIsPromotion($query, $promotion_flg)
    {
        return $query->where('services.promotion_flg', $promotion_flg);
    }

    public function scopeIsFilters($query, $filters = [])
    {
        if (!empty($filters)) {
            if (isset($filters['keywords']) && $filters['keywords'] != "") {
                $query->where(function ($query) use ($filters) {
                    return $query->where("services.service_name", 'like', '%' . $filters['keywords'] . '%')
                        ->orWhere("services.service_volumetric_mass", 'like', '%' . $filters['keywords'] . '%')
                        ->orWhere("services.service_code", 'like', '%' . $filters['keywords'] . '%');
                });
            }
        }
        return $query;
    }

    public function associateWithService()
    {
        return $this->belongsTo(AssociateWithService::class, 'service_id', 'service_id');
    }

    public function getActiveNameAttribute()
    {
        $arr = [
            ACTIVE => 'Đang hoạt động',
            INACTIVE => 'Dừng hoạt động',
        ];
        return $arr[$this->active_flg];
    }

    public function getPromotionNameAttribute()
    {
        $arr = [
            NO_PROMOTION => 'Dịch vụ thường',
            IS_PROMOTION => 'Dịch vụ khuyến mãi',
            IS_EPACKET => 'Dịch vụ epackage',
        ];
        return $arr[$this->promotion_flg];
    }
}
