<?php

namespace App\Models;

use Illuminate\Support\Facades\DB;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class SaleTeam extends Model
{
    protected $table = 'sales_teams';
    protected $primaryKey = 'sale_team_id';
    protected $guarded = [];
    use HasFactory;

    public function scopeIsShow($query)
    {
        return $query->where('sales_teams.delete_flg', NO_DELETE)->where('sales_teams.active_flg', ACTIVE);
    }


    public function scopeIsPaginate($query, $paginate)
    {
        $limit = !empty($paginate['limit']) ? $paginate['limit'] : 10;
        $page = !empty($paginate['page']) ? $paginate['page'] : 1;

        return $query->paginate($limit, ['*'], 'page', $page);
    }

    public function members()
    {
        return $this->hasMany(SaleMember::class, 'sale_team_id', 'sale_team_id')
            ->leftJoin('users', 'sales_members.user_id', 'users.user_id')
            ->leftJoin('shipments', function ($join) {
                $join->on('sales_members.user_id', '=', 'shipments.user_id')
                     ->where('shipments.delete_flg', NO_DELETE);
            })
            ->where('sales_members.delete_flg', NO_DELETE)
            ->where('users.delete_flg', NO_DELETE)
            ->select(
                'sale_member_id',
                'member_kind',
                'users.user_contact_name',
                'sales_members.user_id',
                'users.user_code',
                DB::raw('COALESCE(SUM(shipment_amount_profit), 0) as member_profit')
            )->groupBy('sales_members.sale_member_id');

            
    }
}
