<?php

namespace App\Models;

use Illuminate\Support\Facades\DB;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class SaleLinkFwd extends Model
{
    protected $table = 'sale_link_fwds';
    protected $primaryKey = 'sale_link_fwd_id';
    protected $guarded = [];
    use HasFactory;

    public function saleAccount()
    {
        return $this->belongsTo(User::class, 'sale_id', 'user_id');
    }

    public function scopeIsShow($query)
    {
        return $query->where('sale_link_fwds.delete_flg', NO_DELETE)->where('sale_link_fwds.active_flg', ACTIVE);
    }

    public function scopeIsPaginate($query, $paginate = null)
    {
        $limit = !empty($paginate['limit']) ? $paginate['limit'] : 10;
        $page = !empty($paginate['page']) ? $paginate['page'] : 1;

        return $query->paginate($limit, ['*'], 'page', $page);
    }

    public function leader()
    {
        return $this->belongsTo(SaleMember::class, 'sale_id', 'user_id')
            ->leftJoin('sales_teams', 'sales_members.sale_team_id', 'sales_teams.sale_team_id')
            ->leftJoin('users', 'sales_teams.leader_id', 'users.user_id')
            ->select('users.user_code', 'users.user_id', 'users.user_contact_name');
    }
    public function companies()
    {
        return $this->hasMany(SaleLinkFwd::class, 'sale_id', 'sale_id')
            ->where('sale_link_fwds.delete_flg', NO_DELETE)->where('sale_link_fwds.active_flg', ACTIVE)
            ->leftJoin('users', 'sale_link_fwds.fwd_id', 'users.user_id')
            ->leftJoin('shipments', 'sale_link_fwds.fwd_id', 'shipments.user_id')
            ->leftJoin('packages', 'shipments.shipment_id', 'packages.shipment_id')
            ->select(
                'users.user_code',
                'users.user_id',
                'users.user_company_name',
                'sale_link_fwds.sale_id',
                'sale_link_fwds.fwd_id',
                'sale_link_fwds.sale_link_fwd_id',
                DB::raw('SUM(package_charged_weight) as fw_weight')
            )
            ->groupBy('sale_link_fwds.fwd_id');
    }

    public function shipmentWeight() {
        
    }
}
