<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SaleKpi extends Model
{
    protected $table = 'sale_kpis';
    protected $primaryKey = 'sale_kpi_id';
    protected $guarded = [];
    use HasFactory;

    public function scopeIsShow($query)
    {
        return $query->where('sale_kpis.delete_flg', NO_DELETE)->where('sale_kpis.active_flg', ACTIVE);
    }

    public function range_kpis()
    {
        return $this->hasMany(RangeKpi::class, 'sale_kpi_id', 'sale_kpi_id');
    }


    public function scopeIsPaginate($query, $paginate)
    {
        $limit = isset($paginate['limit']) ? $paginate['limit'] : 10;
        $page = isset($paginate['page']) ? $paginate['page'] : 1;
        return $query->paginate($limit, ['*'], 'page', $page);
    }
}
