<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Recharge extends Model
{
    protected $table = 'recharges';
    protected $primaryKey = 'recharge_id';
    protected $guarded = [];
    use HasFactory;

    public function scopeIsShow($query)
    {
        return $query->where('recharges.active_flg', ACTIVE)->where('recharges.active_flg', NO_DELETE);
    }

    public function scopeIsActive($query)
    {
        return $query->where('recharges.active_flg', ACTIVE)->where('recharges.active_flg', NO_DELETE);
    }

    public function scopeIsFilters($query, $filters)
    {
        if (isset($filters['status'])) {
            $query->where('recharges.status', $filters['status']);
        }
        if (isset($filters['start_date']) && isset($filters['end_date'])) {
            $start_date = Carbon::parse($filters['start_date'])->toDateTimeLocalString();
            $end_date = Carbon::parse($filters['end_date'])->endOfDay()->toDateTimeLocalString();
            $query->whereBetween('recharges.created_at', [$start_date, $end_date]);
        }
        if (isset($filters['status']) && $filters['status'] != '') {
            $query->where('recharges.status',  $filters['status']);
        }
        if (isset($filters['keywords']) && $filters['keywords'] != '') {
            if (isset($filters['key_type']) && in_array($filters['key_type'], ['code', 'note'])) {
                switch ($filters['key_type']) {
                    case 'code':
                        $filters['key_type'] = 'code';
                        break;
                    case 'note':
                        $filters['key_type'] = 'note';
                        break;
                    default:
                        break;
                }
                $query->where('recharges.' . $filters['key_type'], 'like', '%' . $filters['keywords'] . "%");
            } else if (isset($filters['keywords']) && $filters['keywords'] != '') {
                $keywords = convertSearchString($filters['keywords']);
                $query->where(function ($q) use ($keywords) {
                    return $q->where('recharges.code', 'like', $keywords)
                        ->orWhere('recharges.note', 'like', $keywords);
                });
            }
        }
        return $query;
    }

    public function scopeIsOrderBy($query, $order_keys)
    {
        if (!empty($order_keys)) {
            foreach ($order_keys as $key => $value) {
                $query->orderBy('recharges.' . $key, $value);
            }
        } else {
            $query->orderBy('recharges.updated_at', 'desc');
        }
        return $query;
    }

    public function scopeIsPaginate($query, $paginate)
    {
        $limit = isset($paginate['limit']) ? $paginate['limit'] : 10;
        $page = isset($paginate['page']) ? $paginate['page'] : 1;
        return $query->paginate($limit, ['*'], 'page', $page);
    }

    public function getUser()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function getAdmin()
    {
        return $this->belongsTo(User::class, 'admin_id');
    }
}
