<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Receiver extends Model
{
    protected $table = 'receivers';
    protected $primaryKey = 'receiver_id';
    protected $guarded = [];
    use HasFactory;

    public function scopeIsShow($query)
    {
        return $query->where('receivers.delete_flg', NO_DELETE)->where('receivers.active_flg', ACTIVE);
    }

    public function scopeIsDelete($query, $delete_flg)
    {
        return $query->where('receivers.delete_flg', $delete_flg);
    }

    public function scopeIsUser($query, $user_id)
    {
        return $query->where('receivers.user_id', $user_id);
    }

    public function scopeIsActive($query, $active_flg)
    {
        return $query->where('receivers.active_flg', $active_flg);
    }
}
