<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PromotionService extends Model
{
    protected $table = 'promotion_services';
    protected $primaryKey = 'promotion_service_id';
    protected $guarded = [];
    use HasFactory;

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id', 'user_id')->isDelete(NO_DELETE);
    }

    public function scopeIsDelete($query, $delete_flg)
    {
        return $query->where('promotion_services.delete_flg', $delete_flg);
    }

    public function scopeIsActive($query, $active_flg)
    {
        return $query->where('promotion_services.active_flg', $active_flg);
    }
}
