<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PriceListZone extends Model
{
    protected $table = 'price_list_zone';
    protected $primaryKey = 'price_list_zone_id';
    protected $guarded = [];
    use HasFactory;

    public function subPriceListZone()
    {
        return $this->hasMany(SubPriceListZone::class, 'price_list_zone_id', 'price_list_zone_id');
    }

    public function service()
    {
        return $this->belongsTo(Service::class, 'service_id', 'service_id');
    }

    public function country()
    {
        return $this->belongsTo(Country::class, 'country_id', 'country_id');
    }

    public function scopeIsActive($query, $active_flg = ACTIVE)
    {
        return $query->where('active_flg', $active_flg);
    }

    public function scopeIsDelete($query, $delete_flg = DELETED)
    {
        return $query->where('delete_flg', $delete_flg);
    }

    public function getPriceListZoneTypeNameAttribute()
    {
        $arr = [
            SUB_CHILD_PRICE_LIST_TYPE_COUNTRY => 'Theo quốc gia',
            SUB_CHILD_PRICE_LIST_TYPE_STATE => 'Theo tiểu bang',
            SUB_CHILD_PRICE_LIST_TYPE_CITY => 'Theo thành phố',
            SUB_CHILD_PRICE_LIST_TYPE_POST_CODE => 'Theo mã bưu chính',
        ];
        return $arr[$this->price_list_zone_type];
    }
}
