<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PriceListUser extends Model
{
    protected $table = 'price_list_user';
    protected $primaryKey = 'price_list_user_id';
    protected $guarded = [];
    use HasFactory;

    public function scopeIsDelete($query, $delete_flg)
    {
        return $query->where('price_list_user.delete_flg', $delete_flg);
    }

    public function scopeIsUser($query, $user_id)
    {
        return $query->where('price_list_user.user_id', $user_id);
    }

    public function scopeIsActive($query, $active_flg)
    {
        return $query->where('price_list_user.active_flg', $active_flg);
    }

    public function scopeIsShow($query)
    {
        return $query->where('price_list_user.active_flg', ACTIVE)->where('price_list_user.delete_flg', NO_DELETE);
    }
}
