<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class PriceList extends Model
{
    protected $table = 'price_list';
    protected $primaryKey = 'price_list_id';
    protected $guarded = [];
    use HasFactory;

    public function childPriceList()
    {
        return $this->hasMany(ChildPriceList::class, 'price_list_id', 'price_list_id')->isActive(ACTIVE)->isDelete(NO_DELETE);
    }
    
    public function scopeIsFilters($query, $filters = [])
    {
        if (!empty($filters)) {
            if (
                (isset($filters['date_range']['start_date']) && $filters['date_range']['start_date'] != "")
                && isset($filters['date_range']['end_date']) && $filters['date_range']['end_date'] != ""
            ) {
                $start_date = Carbon::parse($filters['date_range']['start_date'])->startOfDay()->toDateTimeLocalString();
                $end_date = Carbon::parse($filters['date_range']['end_date'])->endOfDay()->toDateTimeLocalString();
                $query->whereBetween("price_list.created_at", [$start_date, $end_date]);
            }
            if (isset($filters['active_flg']) && $filters['active_flg'] != "") {
                $query->isActive($filters['active_flg']);
            }
            if (isset($filters['keywords']) && $filters['keywords'] != "") {
                $query->where(function ($query) use ($filters) {
                    return $query->where('price_list.price_list_title', 'like', '%' . $filters['keywords'] . '%');
                });
            }
        }
        return $query;
    }

    public function scopeIsDelete($query, $delete_flg)
    {
        return $query->where('price_list.delete_flg', $delete_flg);
    }

    public function scopeIsActive($query, $active_flg)
    {
        return $query->where('price_list.active_flg', $active_flg);
    }

    public function getActiveNameAttribute()
    {
        $arr = [
            ACTIVE => 'Đang hoạt động',
            INACTIVE => 'Dừng hoạt động',
        ];
        return $arr[$this->active_flg];
    }
}
