<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Position extends Model
{
    protected $table = 'positions';
    protected $primaryKey = 'position_id';
    protected $guarded = [];
    use HasFactory;

    public function menusByPosition()
    {
        return $this->hasMany(MenuByPosition::class, 'position_id', 'position_id');
    }

    public function scopeIsDelete($query, $delete_flg)
    {
        return $query->where('positions.delete_flg', $delete_flg);
    }
    public function scopeIsShow($query)
    {
        return $query->where('positions.delete_flg', NO_DELETE)->where('positions.active_flg', ACTIVE);
    }

    public function scopeIsActive($query, $active_flg)
    {
        return $query->where('positions.active_flg', $active_flg);
    }

    public function getActiveNameAttribute()
    {
        $arr = [
            ACTIVE => 'Đang hoạt động',
            INACTIVE => 'Ngừng hoạt động',
        ];
        return $arr[$this->active_flg];
    }

    public function getLimitAmountNameAttribute()
    {
        $arr = [
            NO_LIMIT => 'Không giới hạn',
            LIMITED => 'Có giới hạn',
        ];
        return $arr[$this->limit_amount_flg];
    }
}
