<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PackageSg extends Model
{
    protected $table = 'package_surchage_goods';
    protected $primaryKey = 'package_surchage_good_id';
    protected $guarded = [];
    use HasFactory;

    public function scopeIsShow($query)
    {
        return $query->where('package_surchage_goods.delete_flg', NO_DELETE)->where('package_surchage_goods.active_flg', ACTIVE);
    }

    public function scopeIsPaginate($query, $paginate = null)
    {
        $limit = !empty($paginate['limit']) ? $paginate['limit'] : 10;
        $page = !empty($paginate['page']) ? $paginate['page'] : 1;

        return $query->paginate($limit, ['*'], 'page', $page);
    }

    public function mawb(){
        return $this->belongsTo(ShipmentTracktry::class, 'sm_tracktry_id', 'sm_tracktry_id');
    }
}
