<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Package extends Model
{
    protected $table = 'packages';
    protected $primaryKey = 'package_id';
    protected $guarded = [];
    use HasFactory;

    public function processingStaff()
    {
        return $this->belongsTo(User::class, 'processing_staff_id', 'user_id');
    }

    public function scopeIsShow($query)
    {
        return $query->where('packages.delete_flg', NO_DELETE)->where('packages.active_flg', ACTIVE);
    }

    public function scopeIsFilters($query)
    {
        $arr_status = [
            SHIPMENT_STATUS_CREATE,
            SHIPMENT_STATUS_IMPORTED,
            SHIPMENT_STATUS_EXPORED,
            SHIPMENT_STATUS_RETURNED,
            SHIPMENT_STATUS_HOLD,
            SHIPMENT_STATUS_TRANSIT_HN,
        ];
        if ((isset($filters['package_status']) && in_array($filters['package_status'], $arr_status))) {
            $query->where("packages.package_status", $filters['package_status']);
        }

        if (isset($filters['filter_by']) && in_array($filters['filter_by'], [])) {
            $query->where($filters['filter_by'], 'like', '%' . $filters['keywords'] . '%');
        }

        if (isset($filters['keywords']) && $filters['keywords'] != '') {
            $query->where(function ($where) use ($filters) {
                $where->where("packages.package_hawb_code", 'like', '%' . $filters['keywords'] . '%')
                    ->orWhere("packages.package_tracking_code", 'like', '%' . $filters['keywords'] . '%')
                    ->orWhere("packages.bag_code", 'like', '%' . $filters['keywords'] . '%')
                    ->orWhere("packages.carrier_code", 'like', '%' . $filters['keywords'] . '%')
                    ->orWhere("users.user_contact_name", 'like', '%' . $filters['keywords'] . '%');
            });
        }

        return $query;
    }

    public function getPackageTypeNameAttribute()
    {
        $arr = config('constans.constans.package_types');
        return $arr[$this->package_type];
    }

    public function getPackageStatusNameAttribute()
    {
        $arr = config('constans.constans.package_status');
        return $arr[$this->package_status];
    }

    public function scopeIsPaginate($query, $paginate = null)
    {
        $limit = !empty($paginate['limit']) ? $paginate['limit'] : 10;
        $page = !empty($paginate['page']) ? $paginate['page'] : 1;

        return $query->paginate($limit, ['*'], 'page', $page);
    }

    public function packages_sg()
    {
        return $this->hasMany(PackageSg::class, 'package_id', 'package_id')
            ->leftJoin('surcharge_goods', 'package_surchage_goods.surcharge_goods_id', 'surcharge_goods.surcharge_goods_id')
            ->select(
                'package_surchage_goods.package_surchage_good_id',
                'package_surchage_goods.external_surcharge_name',
                'package_surchage_goods.price',
                'package_surchage_goods.count',
                'surcharge_goods.surcharge_goods_name',
            );
    }

    public function history_scans()
    {
        return $this->hasMany(HistoryScan::class, 'package_id', 'package_id')
            ->where('history_scan.active_flg', ACTIVE)->where('history_scan.delete_flg', NO_DELETE)
            ->leftJoin('users', 'history_scan.scan_by', 'users.user_id')
            ->select(
                'user_contact_name',
                'user_code',
                'status',
                DB::raw(
                    "CASE
                        WHEN status = 0 THEN 'Create Bill'
                        WHEN status = 1 THEN 'Import Bill'
                        WHEN status = 2 THEN 'Export Bill'
                        WHEN status = 3 THEN 'Return Bill'
                        WHEN status = 4 THEN 'Hold'
                        WHEN status = 6 THEN 'Transit'
                        ELSE 'Other'
                    END as status_label"
                )
            );
    }

    public function getPackageApproveNameAttribute()
    {
        try {
            $arr = config('constans.constans.package_approve_status');
            return $arr[$this->package_approve] ?? '';
        } catch (\Throwable $th) {
            return '';
        }
    }
}
