<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class OrderPickup extends Model
{
    protected $table = 'orders_pickup';
    protected $primaryKey = 'order_pickup_id';
    protected $guarded = [];
    use HasFactory;

    public function scopeIsShow($query)
    {
        return $query->where('orders_pickup.delete_flg', NO_DELETE)->where('orders_pickup.active_flg', ACTIVE);
    }

    public function scopeIsPaginate($query, $paginate)
    {
        $limit = !empty($paginate['limit']) ? $paginate['limit'] : 10;
        $page = !empty($paginate['page']) ? $paginate['page'] : 1;

        return $query->paginate($limit, ['*'], 'page', $page);
    }

    public function branch()
    {
        return $this->belongsTo(Branch::class, 'branch_id', 'branch_id');
    }


    public function userReceiver()
    {
        return $this->belongsTo(User::class, 'user_receiver_id', 'user_id');
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id', 'user_id');
    }

    public function shipper()
    {
        return $this->belongsTo(ShipperLocation::class, 'shipper_location_id', 'shipper_location_id')
        ->leftJoin('users', 'shipper_locations.shipper_id', 'users.user_id');
    }

    public function fwd()
    {
        return $this->belongsTo(User::class, 'fwd_id', 'user_id');
    }

    public function sale()
    {
        return $this->belongsTo(User::class, 'sale_id', 'user_id');
    }

    public function user_created()
    {
        return $this->belongsTo(User::class, 'user_id', 'user_id');
    }

    public function scopeIsFilters($query, $filters = [])
    {
        if (!empty($filters)) {
            if (
                (isset($filters['date_range']['start_date']) && $filters['date_range']['start_date'] != "")
                && isset($filters['date_range']['end_date']) && $filters['date_range']['end_date'] != ""
            ) {
                $start_date = Carbon::parse($filters['date_range']['start_date'])->startOfDay()->toDateTimeLocalString();
                $end_date = Carbon::parse($filters['date_range']['end_date'])->endOfDay()->toDateTimeLocalString();
                $query->whereBetween("orders_pickup.created_at", [$start_date, $end_date]);
            }
            if (isset($filters['keywords']) && $filters['keywords'] != "") {
                $query->leftJoin('users', 'orders_pickup.user_id', 'users.user_id');
                $query->where(function ($query) use ($filters) {
                    return $query->where('orders_pickup.order_pickup_code', 'like', '%' . $filters['keywords'] . '%')
                        ->orWhere('orders_pickup.order_pickup_awb', 'like', '%' . $filters['keywords'] . '%')
                        ->orWhere('orders_pickup.order_pickup_address', 'like', '%' . $filters['keywords'] . '%')
                        ->orWhere('orders_pickup.order_pickup_note', 'like', '%' . $filters['keywords'] . '%')
                        ->orWhere('orders_pickup.order_pickup_number_packages', 'like', '%' . $filters['keywords'] . '%')
                        ->orWhere('orders_pickup.order_pickup_gross_weight', 'like', '%' . $filters['keywords'] . '%')
                        ->orWhere('users.user_contact_name', 'like', '%' . $filters['keywords'] . '%')
                        ->orWhere('orders_pickup.order_pickup_phone', 'like', '%' . $filters['keywords'] . '%');
                });
            }
            if (isset($filters['order_pickup_status']) && $filters['order_pickup_status'] != "") {
                $query->where('orders_pickup.order_pickup_status', $filters['order_pickup_status']);
            }
            if (isset($filters['branch_id']) && $filters['branch_id'] != "") {
                $query->where('orders_pickup.branch_id', $filters['branch_id']);
            }
        }
        return $query;
    }

    public function scopeIsDelete($query, $delete_flg)
    {
        return $query->where('orders_pickup.delete_flg', $delete_flg);
    }

    public function scopeIsActive($query, $active_flg)
    {
        return $query->where('orders_pickup.active_flg', $active_flg);
    }

    public function getOrderPickupTypeNameAttribute()
    {
        $arr = config('constans.constans.vehicles');
        return $arr[$this->order_pickup_type];
    }

    public function getOrderPickupStatusNameAttribute()
    {
        $arr = config('constans.constans.order_pickup_status');
        return $arr[$this->order_pickup_status];
    }
}
