<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class OperatingCost extends Model
{
    protected $table = 'operating_costs';
    protected $primaryKey = 'operating_cost_id';
    protected $guarded = [];
    use HasFactory;

    public function parentOperatingCost()
    {
        return $this->belongsTo(OperatingCost::class, 'parent_operating_cost_id', 'operating_cost_id');
    }

    public function childOperatingCost()
    {
        return $this->hasMany(OperatingCost::class, 'parent_operating_cost_id', 'operating_cost_id');
    }

    public function scopeIsActive($query, $active_flg)
    {
        return $query->where('operating_costs.active_flg', $active_flg);
    }

    public function scopeIsDelete($query, $delete_flg)
    {
        return $query->where('operating_costs.delete_flg', $delete_flg);
    }
}
