<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Notification extends Model
{
    protected $table = 'notifications';
    protected $primaryKey = 'notification_id';
    protected $guarded = [];
    use HasFactory;

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id', 'user_id');
    }

    public function scopeIsFilters($query, $filters = [])
    {
        if (!empty($filters)) {
            if (
                (isset($filters['date_range']['start_date']) && $filters['date_range']['start_date'] != "")
                && isset($filters['date_range']['end_date']) && $filters['date_range']['end_date'] != ""
            ) {
                $start_date = Carbon::parse($filters['date_range']['start_date'])->startOfDay()->toDateTimeLocalString();
                $end_date = Carbon::parse($filters['date_range']['end_date'])->endOfDay()->toDateTimeLocalString();
                $query->whereBetween("notifications.created_at", [$start_date, $end_date]);
            }
            if (isset($filters['keywords']) && $filters['keywords'] != "") {
                $query->where(function ($query) use ($filters) {
                    return $query->where('notifications.notification_title', 'like', '%' . $filters['keywords'] . '%');
                });
            }
            if (isset($filters['notification_important']) && $filters['notification_important'] != "") {
                $query->where('notifications.notification_important', $filters['notification_important']);
            }
        }
        return $query;
    }

    public function scopeIsDelete($query, $delete_flg)
    {
        return $query->where('notifications.delete_flg', $delete_flg);
    }

    public function scopeIsActive($query, $active_flg)
    {
        return $query->where('notifications.active_flg', $active_flg);
    }
}
