<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class MenuByPosition extends Model
{
    protected $table = 'menus_by_position';
    protected $primaryKey = 'menu_by_position_id';
    protected $guarded = [];
    use HasFactory;

    public function scopeIsPosition($query, $position_id){
        return $query->where('menus_by_position.position_id', $position_id);
    }

    public function scopeIsMenuKey($query, $menu_key){
        return $query->where('menus_by_position.menu_key', $menu_key);
    }
}
