<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class LogoService extends Model
{
    protected $table = 'logo_services';
    protected $primaryKey = 'logo_service_id';
    protected $guarded = [];
    use HasFactory;

    public function scopeIsFilters($query, $filters = [])
    {
        if (!empty($filters)) {
            if (
                (isset($filters['date_range']['start_date']) && $filters['date_range']['start_date'] != "")
                && isset($filters['date_range']['end_date']) && $filters['date_range']['end_date'] != ""
            ) {
                $start_date = Carbon::parse($filters['date_range']['start_date'])->startOfDay()->toDateTimeLocalString();
                $end_date = Carbon::parse($filters['date_range']['end_date'])->endOfDay()->toDateTimeLocalString();
                $query->whereBetween("services.created_at", [$start_date, $end_date]);
            }
            if (isset($filters['keywords']) && $filters['keywords'] != "") {
                $query->where(function ($query) use ($filters) {
                    return $query->where('services.service_name', 'like', '%' . $filters['keywords'] . '%');
                });
            }
        }
        return $query;
    }
}
