<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ListAreaOfZone extends Model
{
    protected $table = 'list_area_of_zone';
    protected $primaryKey = 'list_area_of_zone_id';
    protected $guarded = [];
    use HasFactory;

    public function country()
    {
        return $this->belongsTo(Country::class, 'country_id', 'country_id');
    }

    public function state()
    {
        return $this->belongsTo(State::class, 'state_id', 'state_id');
    }

    public function city()
    {
        return $this->belongsTo(City::class, 'city_id', 'city_id');
    }

    public function town()
    {
        return $this->belongsTo(Town::class, 'town_id', 'town_id');
    }
}
