<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ItemChildPriceList extends Model
{
    protected $table = 'items_child_price_list';
    protected $primaryKey = 'item_child_price_list_id';
    protected $guarded = [];
    use HasFactory;

    public function scopeIsDelete($query, $delete_flg)
    {
        return $query->where('items_child_price_list.delete_flg', $delete_flg);
    }

    public function scopeIsActive($query, $active_flg)
    {
        return $query->where('items_child_price_list.active_flg', $active_flg);
    }
}
