<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Invoice extends Model
{
    protected $table = 'invoices';
    protected $primaryKey = 'invoice_id';
    protected $guarded = [];
    use HasFactory;

    public function scopeIsShow($query)
    {
        return $query->where('invoices.delete_flg', NO_DELETE)->where('invoices.active_flg', ACTIVE);
    }

    public function getInvoiceUnitNameAttribute()
    {
        $arr = config('constans.constans.invoice_units');
        return $arr[$this->invoice_unit];
    }
}
