<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class InitiallizeLabelHistory extends Model
{
    protected $table = 'initiallize_label_histories';
    protected $primaryKey = 'initiallize_label_history_id';
    protected $guarded = [];
    use HasFactory;

    public function shipment()
    {
        return $this->belongsTo(Shipment::class, 'shipment_id', 'shipment_id');
    }

    public function scopeIsFilters($query, $filters = [])
    {
        $query->join('users', 'users.user_id', '=', 'initiallize_label_histories.user_id')
            ->join('shipments', 'shipments.shipment_id', '=', 'initiallize_label_histories.shipment_id')
            ->select('initiallize_label_histories.*', 'users.user_name', 'users.user_code', 'users.user_contact_name', 'users.user_phone', 'shipments.shipment_code');
        if (!empty($filters)) {
            if (
                (isset($filters['date_range']['start_date']) && $filters['date_range']['start_date'] != "")
                && isset($filters['date_range']['end_date']) && $filters['date_range']['end_date'] != ""
            ) {
                $start_date = Carbon::parse($filters['date_range']['start_date'])->startOfDay()->toDateTimeLocalString();
                $end_date = Carbon::parse($filters['date_range']['end_date'])->endOfDay()->toDateTimeLocalString();
                $query->whereBetween("initiallize_label_histories.created_at", [$start_date, $end_date]);
            }

            if (isset($filters['keywords']) && $filters['keywords'] != "") {
                $query->where(function ($query) use ($filters) {
                    return $query->where("users.user_name", 'like', '%' . $filters['keywords'] . '%')
                        ->orWhere("users.user_code", 'like', '%' . $filters['keywords'] . '%')
                        ->orWhere("users.user_contact_name", 'like', '%' . $filters['keywords'] . '%')
                        ->orWhere("users.user_phone", 'like', '%' . $filters['keywords'] . '%')
                        ->orWhere("shipments.shipment_code", 'like', '%' . $filters['keywords'] . '%');
                });
            }
        }
        return $query;
    }

    public function getInitiallizeLabelHistoryKindNameAttribute()
    {
        $arr = config('constans.constans.api_labels');
        return $arr[$this->initiallize_label_history_kind] ?? '';
    }
}
