<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class FwdCostByService extends Model
{
    protected $table = 'fwd_costs';
    protected $primaryKey = 'fwd_cost_id';
    protected $guarded = [];
    use HasFactory;

    public function scopeIsShow($query)
    {
        return $query->where('fwd_costs.delete_flg', NO_DELETE)->where('fwd_costs.active_flg', ACTIVE);
    }

    public function scopeIsPaginate($query, $paginate = null)
    {
        $limit = !empty($paginate['limit']) ? $paginate['limit'] : 10;
        $page = !empty($paginate['page']) ? $paginate['page'] : 1;

        return $query->paginate($limit, ['*'], 'page', $page);
    }

    public function fwdCosts()
    {
        return $this->hasMany(FwdCostByService::class, 'leader_id', 'leader_id')
            ->leftJoin('users', 'fwd_costs.fwd_id', 'users.user_id')
            ->leftJoin('services', 'fwd_costs.service_id', 'services.service_id')
            ->select('fwd_costs.*', 'users.user_company_name', 'users.user_code', 'services.service_name')
            ->groupBy('fwd_costs.fwd_cost_id');
    }
}
