<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class FinancialManagement extends Model
{
    protected $table = 'financial_management';
    protected $primaryKey = 'financial_id';
    protected $guarded = [];
    use HasFactory;


    public function scopeIsShow($query)
    {
        return $query->where('financial_management.delete_flg', NO_DELETE)
            ->where('financial_management.active_flg', ACTIVE);
    }
    
    public function scopeIsPaginate($query, $paginate = null)
    {
        $limit = !empty($paginate['limit']) ? $paginate['limit'] : 10;
        $page = !empty($paginate['page']) ? $paginate['page'] : 1;

        return $query->paginate($limit, ['*'], 'page', $page);
    }
}
