<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class DiscountUser extends Model
{
    protected $table = 'discount_users';
    protected $primaryKey = 'discount_user_id';
    protected $guarded = [];
    use HasFactory;

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id', 'user_id')->isDelete(NO_DELETE);
    }

    public function discountUserWeightLevels()
    {
        return $this->hasMany(DiscountUserWeightLevel::class, 'discount_user_id', 'discount_user_id');
    }

    public function service()
    {
        return $this->belongsTo(Service::class, 'service_id', 'service_id')->isDelete(NO_DELETE);
    }

    public function scopeIsDelete($query, $delete_flg)
    {
        return $query->where('discount_users.delete_flg', $delete_flg);
    }

    public function scopeIsActive($query, $active_flg)
    {
        return $query->where('discount_users.active_flg', $active_flg);
    }


    public function scopeIsShow($query)
    {
        return $query->where('discount_users.delete_flg', NO_DELETE)
            ->where('discount_users.active_flg', ACTIVE);
    }

    public function scopeIsUser($query, $user_id)
    {
        return $query->where('discount_users.user_id', $user_id);
    }

    public function scopeIsService($query, $service_id)
    {
        return $query->where('discount_users.service_id', $service_id);
    }

    public function getActiveNameAttribute()
    {
        $arr = [
            ACTIVE => 'Đang hoạt động',
            INACTIVE => 'Dừng hoạt động',
        ];
        return $arr[$this->active_flg];
    }
}
