<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Debit extends Model
{
    protected $table = 'debits';
    protected $primaryKey = 'debit_id';
    protected $guarded = [];
    use HasFactory;

    public function scopeIsShow($query)
    {
        return $query->where('debits.delete_flg', NO_DELETE)->where('debits.active_flg', ACTIVE);
    }

    public function scopeIsPaginate($query, $paginate = null)
    {
        $limit = !empty($paginate['limit']) ? $paginate['limit'] : 10;
        $page = !empty($paginate['page']) ? $paginate['page'] : 1;

        return $query->paginate($limit, ['*'], 'page', $page);
    }

    public function scopeIsFilters($query, $filters = null)
    {
        if ($filters) {
            if (isset($filters['debit_status'])) {
                $query->where('debits.debit_status', $filters['debit_status']);
            }

            if (
                (isset($filters['date_range']['start_date']) && $filters['date_range']['start_date'] != "")
                && isset($filters['date_range']['end_date']) && $filters['date_range']['end_date'] != ""
            ) {
                $start_date = Carbon::parse($filters['date_range']['start_date'])->startOfDay()->toDateTimeLocalString();
                $end_date = Carbon::parse($filters['date_range']['end_date'])->endOfDay()->toDateTimeLocalString();
                $query->whereBetween("debits.created_at", [$start_date, $end_date]);
            }

            if (isset($filters['debit_type']) && $filters['debit_type'] != "") {
                $query->where("debits.debit_type", $filters['debit_type']);
            }

            if (isset($filters['checked_payment_status']) && $filters['checked_payment_status'] != "") {
                $query->where("debits.checked_payment_status", $filters['checked_payment_status']);
            }

            if (isset($filters['keywords']) && $filters['keywords'] != "") {
                $query->where(function ($query) use ($filters) {
                    $filter_by = isset($filters['filter_by']) ? $filters['filter_by'] : 'debit_no';
                    return $query->where("debits.$filter_by", 'like', '%' . $filters['keywords'] . '%');
                });
            }
        }
        return $query;
    }

    public function scopeIsFilters2($query, $filters = null){
        if (isset($request_data['filters'])) {
            $filters = $request_data['filters'];
            if ($filters['filter_by']) {
                $filter_by = $filters['filter_by'];
                $key_filter = [
                    "debit_no" => "debits.debit_no",
                    "customer_code" => "customer.user_code",
                    "customer_company" => "customer.user_company_name",
                    "creator_name" => "creator.user_contact_name",
                ];
                $query->where($key_filter[$filter_by], 'like', '%' . $filters['keywords'] . '%');
            } else {
                $query->where('customer.user_company_name', 'like', '%' . $filters['keywords'] . '%')
                    ->orWhere('customer.user_code', 'like', '%' . $filters['keywords'] . '%')
                    ->orWhere('creator.user_contact_name', 'like', '%' . $filters['keywords'] . '%')
                    ->orWhere('debit_no', 'like', '%' . $filters['keywords'] . '%');
            }

            if (isset($filters['debit_status'])) {
                $query->where('debits.debit_status', $filters['debit_status']);
            }

            if (isset($filters['checked_payment_status']) && $filters['checked_payment_status'] != "") {
                $query->where("debits.checked_payment_status", $filters['checked_payment_status']);
            }

            if (
                (isset($filters['date_range']['start_date']) && $filters['date_range']['start_date'] != "")
                && isset($filters['date_range']['end_date']) && $filters['date_range']['end_date'] != ""
            ) {
                $start_date = Carbon::parse($filters['date_range']['start_date'])->startOfDay()->toDateTimeLocalString();
                $end_date = Carbon::parse($filters['date_range']['end_date'])->endOfDay()->toDateTimeLocalString();
                $query->whereBetween("debits.created_at", [$start_date, $end_date]);
            }

            if (isset($filters['debit_type']) && $filters['debit_type'] != "") {
                $query->where("debits.debit_type", $filters['debit_type']);
            }
        };
        return $query;
    }

    public function checked_payment()
    {
        return $this->belongsTo(CheckedPaymentCash::class, 'debit_no', 'code');
    }

    public function getDebitTypeNameAttribute()
    {
        try {
            $arr = config('constans.constans.debits');
            return $arr[$this->debnit_type] ?? "";
        } catch (\Throwable $th) {
            return "";
        }
    }
    public function getDebitPaymentMethodNameAttribute()
    {
        try {
            $arr = config('constans.constans.payment_status_name');
            return $arr[$this->statement_payment_method] ?? 'Không xác định';
        } catch (\Throwable $th) {
            return "Lỗi";
        }
    }
}
