<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Credit extends Model
{
    protected $table = 'credits';
    protected $primaryKey = 'credit_id';
    protected $guarded = [];
    use HasFactory;

    public function scopeIsShow($query)
    {
        return $query->where('credits.delete_flg', NO_DELETE)->where('credits.active_flg', ACTIVE);
    }

    public function scopeIsPaginate($query, $paginate = null)
    {
        $limit = !empty($paginate['limit']) ? $paginate['limit'] : 10;
        $page = !empty($paginate['page']) ? $paginate['page'] : 1;

        return $query->paginate($limit, ['*'], 'page', $page);
    }

    public function getCreditStatusNameAttribute()
    {
        try {
            $arr = [
                "Chưa thanh toán",
                "Đã thanh toán",
                "Đang xử lý",
            ];
            return $arr[$this->credit_status];
        } catch (\Throwable $th) {
            return "";
        }
    }
    public function getCreditStatusColorAttribute()
    {
        try {
            $arr = [
                "secondary",
                "success",
                "warning",
            ];
            return $arr[$this->credit_status];
        } catch (\Throwable $th) {
            return "info";
        }
    }
}
