<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CountryAndServiceLink extends Model
{
    protected $table = 'country_and_service_links';
    protected $primaryKey = 'country_and_service_link_id';
    protected $guarded = [];
    use HasFactory;

    public function service()
    {
        return $this->belongsTo(Service::class, 'service_id', 'service_id')->isDelete(NO_DELETE);
    }

    public function country()
    {
        return $this->belongsTo(Country::class, 'country_id', 'country_id')->isDelete(NO_DELETE);
    }

    public function scopeIsShow($query)
    {
        return $query->where('country_and_service_links.delete_flg', NO_DELETE)->where('country_and_service_links.active_flg', ACTIVE);
    }

    public function scopeIsFilters($query, $filters = [])
    {
        if (!empty($filters)) {
            if (isset($filters['country_id']) && $filters['country_id'] != "") {
                $query->where('country_and_service_links.country_id', $filters['country_id']);
            }
            if (isset($filters['service_id']) && $filters['service_id'] != "") {
                $query->where('country_and_service_links.service_id', $filters['service_id']);
            }
        }
        return $query;
    }

    public function scopeIsDelete($query, $delete_flg)
    {
        return $query->where('country_and_service_links.delete_flg', $delete_flg);
    }

    public function scopeIsCountry($query, $country_id)
    {
        return $query->where('country_and_service_links.country_id', $country_id);
    }

    public function scopeIsService($query, $service_id)
    {
        return $query->where('country_and_service_links.service_id', $service_id);
    }

    public function scopeIsActive($query, $active_flg)
    {
        return $query->where('country_and_service_links.active_flg', $active_flg);
    }

    public function getActiveNameAttribute()
    {
        $arr = [
            ACTIVE => 'Đang hoạt động',
            INACTIVE => 'Ngừng hoạt động',
        ];
        return $arr[$this->active_flg];
    }

}
