<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Country extends Model
{
    protected $table = 'countries';
    protected $primaryKey = 'country_id';
    protected $guarded = [];
    use HasFactory;

    public function countriesServices()
    {
        return $this->hasMany(CountryAndServiceLink::class, 'country_id', 'country_id')
            ->leftJoin('services', 'services.service_id', '=', 'country_and_service_links.service_id')
            ->select('country_and_service_links.*', 'services.service_id', 'services.service_name');
    }

    public function scopeIsFilters($query, $filters = [])
    {
        if (!empty($filters)) {
            if (isset($filters['keywords']) && $filters['keywords'] != "") {
                $query->where(function ($query) use ($filters) {
                    return $query->where('countries.country_name', 'like', '%' . $filters['keywords'] . '%')
                        ->orWhere('countries.country_code', 'like', '%' . $filters['keywords'] . '%');
                });
            }
            if (isset($filters['active_flg']) && $filters['active_flg'] != "") {
                $query->isActive($filters['active_flg']);
            }
        }
        return $query;
    }

    public function scopeIsDelete($query, $delete_flg)
    {
        return $query->where('countries.delete_flg', $delete_flg);
    }

    public function scopeIsActive($query, $active_flg)
    {
        return $query->where('countries.active_flg', $active_flg);
    }

    public function getActiveNameAttribute()
    {
        $arr = [
            ACTIVE => 'Đang hoạt động',
            INACTIVE => 'Dừng hoạt động',
        ];
        return $arr[$this->active_flg];
    }
}
