<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ChildPriceList extends Model
{
    protected $table = 'child_price_list';
    protected $primaryKey = 'child_price_list_id';
    protected $guarded = [];
    use HasFactory;

    public function itemChildPriceList()
    {
        return $this->hasMany(SubChildPriceList::class, 'child_price_list_id', 'child_price_list_id')->isActive(ACTIVE)->isDelete(NO_DELETE);
    }

    public function scopeIsDelete($query, $delete_flg)
    {
        return $query->where('child_price_list.delete_flg', $delete_flg);
    }

    public function scopeIsActive($query, $active_flg)
    {
        return $query->where('child_price_list.active_flg', $active_flg);
    }
}
