<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Branch extends Model
{
    protected $table = 'branchs';
    protected $primaryKey = 'branch_id';
    protected $guarded = [];
    use HasFactory;

    public function scopeIsShow($query)
    {
        return $query->where('branchs.delete_flg', NO_DELETE)->where('branchs.active_flg', ACTIVE);
    }

    public function scopeIsDelete($query, $delete_flg)
    {
        return $query->where('branchs.delete_flg', $delete_flg);
    }

    public function scopeIsActive($query, $active_flg)
    {
        return $query->where('branchs.active_flg', $active_flg);
    }

    public function getActiveNameAttribute()
    {
        $arr = [
            ACTIVE => 'Đang hoạt động',
            INACTIVE => 'Ngừng hoạt động',
        ];
        return $arr[$this->active_flg];
    }
}
