<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class BagCode extends Model
{
    protected $table = 'bag_codes';
    protected $primaryKey = 'bag_code_id';
    protected $guarded = [];
    use HasFactory;

    public function scopeIsShow($query)
    {
        return $query->where('bag_codes.delete_flg', NO_DELETE)->where('bag_codes.active_flg', ACTIVE);
    }

    public function branch(){
        return $this->belongsTo(Branch::class, 'branch_id', 'branch_id');
    }

    public function bagcodes(){
        return $this->belongsTo(BagCodeItem::class, 'bag_code_id', 'bag_code_id');
    }

    public function scopeIsPaginate($query, $paginate)
    {
        $limit = isset($paginate['limit']) ? $paginate['limit'] : 10;
        $page = isset($paginate['page']) ? $paginate['page'] : 1;
        return $query->paginate($limit, ['*'], 'page', $page);
    }
}
