<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class ApiDocument extends Model
{
    protected $table = 'api_documents';
    protected $primaryKey = 'api_document_id';
    protected $guarded = [];
    use HasFactory;

    public function scopeIsShow($query)
    {
        return $query->where('api_documents.delete_flg', NO_DELETE)->where('api_documents.active_flg', ACTIVE);
    }

    public function scopeIsPaginate($query, $paginate)
    {
        $limit = isset($paginate['limit']) ? $paginate['limit'] : 10;
        $page = isset($paginate['page']) ? $paginate['page'] : 1;
        return $query->paginate($limit, ['*'], 'page', $page);
    }

    public function scopeIsFilters($query, $filters)
    {
        if (!empty($filters)) {
            if (
                (isset($filters['date_range']['start_date']) && $filters['date_range']['start_date'] != "")
                && isset($filters['date_range']['end_date']) && $filters['date_range']['end_date'] != ""
            ) {
                $start_date = Carbon::parse($filters['date_range']['start_date'])->startOfDay()->toDateTimeLocalString();
                $end_date = Carbon::parse($filters['date_range']['end_date'])->endOfDay()->toDateTimeLocalString();
                $query->whereBetween("api_documents.created_at", [$start_date, $end_date]);
            }


            if (isset($filters['keywords']) && $filters['keywords'] != "") {
                $query->where(function ($query) use ($filters) {
                    return $query->where("api_documents.title", 'like', '%' . $filters['keywords'] . '%');
                });
            }
        }
    }
}
