<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class SendEmail extends Mailable
{
    use Queueable, SerializesModels;
    public $details, $code_otp;

    /**
     * Create a new message instance.
     */
    public function __construct($details, $code_otp)
    {
        $this->details = $details;
        $this->code_otp = $code_otp;
    }

    /**
     * Get the message envelope.
     */
    public function build()
    {
        switch ($this->code_otp['kind']) {
            case FORGOT_PASSWORD:
                $this->details['route'] = $this->details['route'];
                break;

            case ACCURACY:
                $this->details['route'] = route('accuracy.show', ['email' => $this->code_otp['email'], 'token' => $this->code_otp['code']]);
                break;

            default:
                # code...
                break;
        }
        return $this->subject('KANGO')->view($this->details['template']);
    }
}
