<?php

namespace App\Jobs;

use App\Mail\SendEmail;
use Illuminate\Bus\Queueable;
use Illuminate\Support\Facades\Mail;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;

class SendEmailJobs implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;
    public $details, $code_otp;

    /**
     * Create a new job instance.
     */
    public function __construct($details, $code_otp)
    {
        $this->details = $details;
        $this->code_otp = $code_otp;
    }

    /**
     * Execute the job.
     */
    public function handle()
    {
        Mail::to($this->details['email'])->send(new SendEmail($this->details, $this->code_otp));
    }
}
