<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use App\Models\MenuByPosition;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Session;

class SetupAuthenticated
{
    /**
     * Get the path the user should be redirected to when they are not authenticated.
     */
    // protected function redirectTo(Request $request): ?string
    // {
    //     return $request->expectsJson() ? null : route('login');
    // }

    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        $route_name = Route::currentRouteName();
        $route_name_replace = str_replace('.', '_', $route_name);
        try {

            if (Auth::check()) {
                if (Auth::user()->user_id == 1) {
                    return $next($request);
                }

                if (
                    Auth::user()->active_flg == INACTIVE
                    || Auth::user()->delete_flg == DELETED
                    || !isset(Auth::user()->position)
                    || !isset(Auth::user()->branch)
                ) {
                    Auth::logout();
                    Session::forget('user_id_' . auth()->id());
                    Session::forget('is_show_modal_' . auth()->id());
                    if ($request->method() == 'POST') {
                        return response()->json([
                            'status' => HTTP_GATEWAY_TIMEOUT,
                            'message' => [
                                'title' => 'Lỗi!',
                                'text' => 'Tài khoản bạn không còn hoạt động.',
                                'icon' => 'error',
                            ]
                        ]);
                    }
                    return redirect()->route('login.show')->with('danger', 'Tài khoản này đã bị khóa');
                }

                $position_id = auth()->user()->position_id;
                $menu = MenuByPosition::isPosition($position_id)->isMenuKey(config("constans.setup-link.$route_name_replace"))->first();
                $public_menu = config("constans.public-menus");
                if (!isset($menu) && !in_array($route_name, $public_menu)) {
                    if (request()->method() != 'POST' && !isset($request->is_api)) {
                        $menu = MenuByPosition::where('position_id', auth()->user()->position_id)->first();
                        $route = collect(config('constans.menus'))->pluck('menus')->flatten(1)->keyBy('primary')[$menu->menu_key]['route'];
                        return redirect()->route($route);
                    } else {
                        return returnResponse(HTTP_BAD_REQUEST, 'Bạn không đủ quyền hạn', null, 'warning');
                    }
                }

                return $next($request);
            } else {
                if (Auth::check()) {
                    if (request()->method() == 'POST') {
                        return response()->json([
                            'status' => HTTP_UNAUTHORIZED,
                            'message' => [
                                'title' => 'Lỗi!',
                                'text' => 'Bạn chưa đăng nhập, xin hãy đăng nhập để trải nghiệm các chức năng.',
                                'icon' => 'error',
                            ]
                        ]);
                    }
                    return abort(HTTP_NOT_FOUND);
                }
                return redirect()->route('login.show')->with('warning', 'Bạn chưa đăng nhập tài khoản');
            }
        } catch (\Throwable $th) {
            return abort(HTTP_NOT_FOUND);
        }
    }
}
